package app.firezone.synk.network;

import android.Manifest;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.bottomnavigation.BottomNavigationView;

import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.google.android.material.navigation.NavigationView;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;

import java.net.UnknownHostException;
import java.util.ArrayList;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.AboutActivity;
import app.firezone.synk.network.Activities.Add_Money_Activity;
import app.firezone.synk.network.Activities.AppUpdateActivity;
import app.firezone.synk.network.Activities.BlockedUsersActivity;
import app.firezone.synk.network.Activities.GamesRulesActivity;
import app.firezone.synk.network.Activities.HelpActivity;
import app.firezone.synk.network.Activities.LoginActivity;
import app.firezone.synk.network.Activities.NoInternetActivity;
import app.firezone.synk.network.Activities.NotificationActivity;
import app.firezone.synk.network.Activities.ReferActivity;
import app.firezone.synk.network.Activities.ScoreActivity;
import app.firezone.synk.network.Activities.TransactionHistoryActivity;
import app.firezone.synk.network.Activities.WalletActivity;
import app.firezone.synk.network.Fragments.HistoryFragment;
import app.firezone.synk.network.Fragments.HomeFragment;
import app.firezone.synk.network.databinding.ActivityMainBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.NotificationModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.ui.Earn.EarnFragment;
import app.firezone.synk.network.Fragments.ProfileFragment;
import app.firezone.synk.network.ui.videos.VideoFragment;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MainActivity extends AppCompatActivity {

    private ActivityMainBinding binding;
    TextView balanceCoin;
    ImageView notification;
    DrawerLayout drawerLayout;
    NavigationView navigationView;

    String privacyUrl, termUrl, website, updateLink;

    private MyApi myApi;

    ImageView menu;

    ArrayList<NotificationModel> mlist =  new ArrayList<>();
    FirebaseRemoteConfig remoteConfig;

    private BottomNavigationView bottomNavigationView;
    private Fragment fragment = null;

    private final Handler handler = new Handler();
    private final int REFRESH_INTERVAL = 5000; // 5 seconds

    private final Runnable refreshRunnable = new Runnable() {
        @Override
        public void run() {
            loadUserData(); // call the function that fetches user data
            handler.postDelayed(this, REFRESH_INTERVAL);
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        loadData();
        binding = ActivityMainBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());



        // 👇 Start refreshing user data
        handler.post(refreshRunnable);

        menu = findViewById(R.id.menu);
        navigationView=  findViewById(R.id.navigationView);

        drawerLayout  =  findViewById(R.id.drawer_layout);

        MobileAds.initialize(this, new OnInitializationCompleteListener() {
            @Override
            public void onInitializationComplete(InitializationStatus initializationStatus) {

            }
        });

        binding.menu.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW);
                browserIntent.setData(Uri.parse(website));
                startActivity(browserIntent);
            }
        });


        binding.notificationIcon.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(MainActivity.this, NotificationActivity.class));
            }
        });


        binding.cardView32.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(MainActivity.this, WalletActivity.class));
            }
        });


        binding.addMoney.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(MainActivity.this, Add_Money_Activity.class));
            }
        });

        navigationView.setNavigationItemSelectedListener(new NavigationView.OnNavigationItemSelectedListener() {
            @Override
            public boolean onNavigationItemSelected(@NonNull MenuItem item) {

                switch (item.getItemId()) {
                    case R.id.nav_player:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        startActivity(new Intent(MainActivity.this, ScoreActivity.class));
                        break;
                    case R.id.abouts_us:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        startActivity(new Intent(MainActivity.this, AboutActivity.class));
                        break;
                    case R.id.nav_rules:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        startActivity(new Intent(MainActivity.this, GamesRulesActivity.class));
                        break;

                    case R.id.nav_invite_frnds:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        startActivity(new Intent(MainActivity.this, ReferActivity.class));
                        break;

                    case R.id.nav_rate_us:
                        final String appPackageName = BuildConfig.APPLICATION_ID;
                        try {

                            startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
                        } catch (ActivityNotFoundException e) {
                            startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + appPackageName)));

                        }
                        break;

                    case R.id.nav_transaction:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        startActivity(new Intent(MainActivity.this, TransactionHistoryActivity.class));
                        break;

                    case R.id.nav_contact_us:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        Intent intent = new Intent(MainActivity.this, HelpActivity.class);
                        startActivity(intent);
                        break;

                    case R.id.nav_blogs:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        Intent browserIntent = new Intent(Intent.ACTION_VIEW);
                        browserIntent.setData(Uri.parse(website));
                        startActivity(browserIntent);
                        break;

                    case R.id.terms_condition:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        Intent browserIntent2 = new Intent(Intent.ACTION_VIEW);
                        browserIntent2.setData(Uri.parse(termUrl));
                        startActivity(browserIntent2);
                        break;

                    case R.id.privacy_policy:
                        drawerLayout.closeDrawer(GravityCompat.START);
                        Intent browserIntent3 = new Intent(Intent.ACTION_VIEW);
                        browserIntent3.setData(Uri.parse(privacyUrl));
                        startActivity(browserIntent3);
                        break;

                }
                return true;

            }
        });



        bottomNavigationView  =  findViewById(R.id.chipNavigation);

        if (savedInstanceState == null){
            getSupportFragmentManager().beginTransaction().replace(R.id.container_layout, new HomeFragment()).commit();
            navigationView.setCheckedItem(R.id.navigation_home);
        }

        replaceFragment(new HomeFragment());

        bottomNavigationView.setBackground(null);
        bottomNavigationView.setOnItemSelectedListener(item -> {
            switch (item.getItemId()) {
                case R.id.navigation_home:
                    replaceFragment(new HomeFragment());
                    break;
                case R.id.navigation_earn:
                    replaceFragment(new EarnFragment());
                    break;
                case R.id.navigation_history:
                    replaceFragment(new HistoryFragment());
                    break;
                case R.id.navigation_profile:
                    replaceFragment(new ProfileFragment());
                    break;
                case R.id.navigation_videos:
                    replaceFragment(new VideoFragment());
                    break;
            };

            return  true;
        });

        FirebaseMessaging.getInstance().subscribeToTopic("all")
                .addOnCompleteListener(task -> {
                    if (task.isSuccessful()) {
                        Log.d("FCM", "Subscribed to topic: all");
                    }
        });





        balanceCoin = findViewById(R.id.balance);
        notification = findViewById(R.id.notification_icon);



        remoteConfig =  FirebaseRemoteConfig.getInstance();
        FirebaseRemoteConfigSettings configSettings =  new FirebaseRemoteConfigSettings.Builder()
                .setMinimumFetchIntervalInSeconds(5)
                .build();
        remoteConfig.setConfigSettingsAsync(configSettings);
        remoteConfig.fetchAndActivate().addOnCompleteListener(new OnCompleteListener<Boolean>() {
            @Override
            public void onComplete(@NonNull Task<Boolean> task) {
                if (task.isSuccessful()){
                    final  String  new_version_code =  remoteConfig.getString("new_version_code");
                    if (Integer.parseInt(new_version_code) > getCurrentVersionCode()){
                        Intent intent  = new Intent(MainActivity.this, AppUpdateActivity.class);
                        intent.putExtra("updateLink", updateLink);
                        startActivity(intent);
                        finish();
                    }
                }
            }
        });

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            checkNotificationPermission();
        } else {
            // Notifications are automatically granted below Android 13
        }


    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        // 👇 Stop the handler when activity is destroyed
        handler.removeCallbacks(refreshRunnable);
    }
    private void loadUserData() {
        long userId = SharedPrefManager.getInstance(MainActivity.this).getUserId();

        if (userId == -1) {
            Toast.makeText(MainActivity.this, "User not found. Please log in again.", Toast.LENGTH_SHORT).show();
            startActivity(new Intent(MainActivity.this, LoginActivity.class));
            finish();
            return;
        }

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    ApiResponse apiResponse = response.body();
                    if (apiResponse.getStatus() == 200 && apiResponse.getUser() != null) {
                        User model = apiResponse.getUser();

                        double totalBalance = model.getWinBalance() + model.getDepoBalance() + model.getBonusBalance();
                        balanceCoin.setText(String.valueOf("₹"+totalBalance));

                        if (!"Active".equalsIgnoreCase(model.getStatus())) {
                            startActivity(new Intent(MainActivity.this, BlockedUsersActivity.class));
                            finish();
                        }
                    } else {
                        Toast.makeText(MainActivity.this, apiResponse.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(MainActivity.this, "Failed to load user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable t) {
                if (t instanceof UnknownHostException) {

                   // Toast.makeText(MainActivity.this, "Please check your internet connection", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "Something went wrong. Try again later.", Toast.LENGTH_SHORT).show();
                    Log.e("API_ERROR", "Failure", t);
                }
            }
        });

    }


    private void noConnectionAndProceed() {
        startActivity(new Intent(MainActivity.this, NoInternetActivity.class));
        finish();
    }

    private void checkNotificationPermission() {
        if (ContextCompat.checkSelfPermission(this, Manifest.permission.POST_NOTIFICATIONS) == PackageManager.PERMISSION_GRANTED) {

        } else if (shouldShowRequestPermissionRationale(Manifest.permission.POST_NOTIFICATIONS)) {
            // Show a message explaining why the permission is needed
            Toast.makeText(this, "Notification permission is needed to send you updates", Toast.LENGTH_SHORT).show();
            requestNotificationPermission();
        } else {
            // Directly request the permission
            requestNotificationPermission();
        }
    }

    private void requestNotificationPermission() {
        // Using the Activity Result API to request permission
        ActivityResultLauncher<String> requestPermissionLauncher =
                registerForActivityResult(new ActivityResultContracts.RequestPermission(), isGranted -> {
                    if (isGranted) {
                       // Toast.makeText(this, "Notification Permission Granted", Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(this, "Notification Permission Denied", Toast.LENGTH_SHORT).show();
                    }
                });

        requestPermissionLauncher.launch(Manifest.permission.POST_NOTIFICATIONS);
    }


    private  int getCurrentVersionCode() {
        PackageInfo packageInfo =  null;
        try {
            packageInfo = getPackageManager().getPackageInfo(getPackageName(), 0);

        }catch (Exception e){
            Log.d("myApp", e.getMessage());

        }
        return  packageInfo.versionCode;
    }




    private  void replaceFragment(Fragment fragment) {
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.replace(R.id.container_layout, fragment);
        fragmentTransaction.commit();
    }



    private void loadData() {
        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();

        call.enqueue(new Callback<ArrayList<AppModel>>() {
            @Override
            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    AppModel model = response.body().get(0); // Fetch first AppModel object
                    website = model.getWebsiteUrl();
                    termUrl = model.getTermsUrl();
                    privacyUrl = model.getPrivacyUrl();
                    updateLink = model.getUpdateLink();

                } else {
                    Toast.makeText(MainActivity.this, "No data found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                // Toast.makeText(MainActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
                if (throwable instanceof UnknownHostException) {
                    // No toast, just silent handling or logging
                    Log.w("Network", "No internet or DNS error", throwable);

                    //Toast.makeText(MainActivity.this, "Please check your internet connection", Toast.LENGTH_SHORT).show();
                } else {
                    // Optionally handle other errors silently too
                    Log.e("Network", "Other network error", throwable);
                }
            }
        });
    }


}